% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixutils.R
\name{ARgenerate}
\alias{ARgenerate}
\title{Generate a unit AR(1) covariance matrix}
\usage{
ARgenerate(n, rho)
}
\arguments{
\item{n}{number of columns/rows}

\item{rho}{correlation parameter}
}
\value{
Toeplitz \eqn{n \times n}{n * n} matrix with 1 on the diagonal
and \eqn{rho^k} on the other diagonals, where \eqn{k} is distance from the
main diagonal.
Used internally but it is useful for generating your own random matrices.
}
\description{
generate AR(1) correlation matrices
}
\examples{
ARgenerate(6, .9)
}
\seealso{
\code{\link[stats:toeplitz]{stats::toeplitz()}}
}
