% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde_precision.R
\name{spde_precision}
\alias{spde_precision}
\title{Precision matrix for Whittle-Matérn fields}
\usage{
spde_precision(kappa, tau, alpha, graph, BC = 1, build = TRUE)
}
\arguments{
\item{kappa}{Range parameter.}

\item{tau}{Precision parameter.}

\item{alpha}{Smoothness parameter (1 or 2).}

\item{graph}{A \code{metric_graph} object.}

\item{BC}{Set boundary conditions for degree=1 vertices. BC =0 gives Neumann
boundary conditions and BC=1 gives stationary boundary conditions.}

\item{build}{If \code{TRUE}, the precision matrix is returned. Otherwise a list
list(i,j,x, nv) is returned.}
}
\value{
Precision matrix or list.
}
\description{
Computes the precision matrix for all vertices for a Whittle-Matérn field.
}
