\name{bothlines}
\alias{bothlines}
\title{Add regression lines to a plot}
\description{
  Add the regression lines of \eqn{y}{y} on \eqn{x}{x} AND \eqn{x}{x} on
  \eqn{y}{y} to the plot. Optionally add the line obtained by allowing
  errors in both variables (Deming regression).
}
\usage{
bothlines(x, y, Dem = FALSE, sdr = 1, col = "black", ...)
}
\arguments{
  \item{x}{Numeric vector}
  \item{y}{Numeric vector}
  \item{Dem}{Logical. Should the Deming regression line be added too?}
  \item{sdr}{Numeric. The assumed ratio of standard deviations used in the Deming
             regression. }
  \item{col}{Colour of the lines. Can be a vector of up to 3 elements,
             one for each line.}
  \item{\dots}{Additional arguments passed on to \code{\link{abline}}, which
               does the actual plotting.}
  }
\value{
  None.
  }
\author{
  Bendix Carstensen, Steno Diabetes Center,
  \url{http://BendixCarstensen.com}
  }
\seealso{\code{\link{abline}}.}
\examples{
data( ox )
oxw <- to.wide(ox)
attach( oxw )
plot( CO, pulse )
abline(0,1)
bothlines( CO, pulse, Dem=TRUE, col=rainbow(3), lwd=2 )
plot( CO, pulse,pch=16 )
abline(0,1, col=gray(0.7), lwd=2)
bothlines( CO, pulse, Dem=TRUE, col=c(rep("transparent",2),"black"), lwd=2 )
}
\keyword{manip}
