% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_search.R
\name{searchFormula}
\alias{searchFormula}
\title{Find matches based on molecular formula}
\usage{
searchFormula(formula, charge, outfolder, base.dbname)
}
\arguments{
\item{formula}{Molecular formula (should be checked by enviPat::check_chemform first!)}

\item{charge}{Charge of formula}

\item{outfolder}{Which folder are your databases stored in?}

\item{base.dbname}{Base database name (without .db suffix)}
}
\value{
Data table with compounds with this molecular formula and the other available information
}
\description{
Goes through database of choice (base database) and retrieves hits that have the  molecular formula of interest.
}
\examples{
 \dontrun{myFolder = tempdir()}
 \dontrun{buildBaseDB(outfolder = myFolder, "lmdb", test = TRUE)}
 \dontrun{searchFormula(formula = c("C7H11N3O2"), charge = 0,
 outfolder = myFolder, base.dbname = c("lmdb"))}
}
\seealso{
\code{\link[RSQLite]{SQLite}}
 \code{\link[data.table]{rbindlist}}
}
