% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEvaluationMeasures.R
\name{getEvaluationMeasures}
\alias{getEvaluationMeasures}
\title{Calculate Evaluation Measures}
\usage{
getEvaluationMeasures(models, k, repNum)
}
\arguments{
\item{models}{list. A list of trained models, like that returned by trainClassifiers()}

\item{k}{integer. Number of folds used in cross-validation}

\item{repNum}{integer. Number of cross-validation rounds}
}
\value{
A dataframe with the following columns: Model, RepNum, Pass_FScore, Pass_Recall, Pass_Precision,
 Fail_FScore, Fail_Recall, Fail_Precision, Accuracy
}
\description{
Calculate evaluation measures using the predictions generated during cross-validation.
}
\examples{
# calculate all seven evaluation measures for each model and each round of cross-validation
\donttest{evalMeasuresDF <- getEvaluationMeasures(models=models, k=5, repNum=10)}

}
