% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateElutionShift.R
\name{calculateElutionShift}
\alias{calculateElutionShift}
\title{Calculate Elution Shift (of a Peak Group)}
\usage{
calculateElutionShift(peakDataList, ptsList)
}
\arguments{
\item{peakDataList}{A list of vectors containing characteristic information about a chromatographic peak - including the retention time range}

\item{ptsList}{A list of 2D matrices containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Elution Shift of a Peak Group (double)
}
\description{
Calculate the Elution Shift of each chromatographic peak in a group of samples. For each sample, the Elution Shift is found by
calculating the difference between the peak apex (max intensity) of that chromatographic peak and the median peak apex of all samples
and normalizing it by the peak base (which is equal to the average difference between the two peak boundaries). The Elution Shift of
the Peak Group is equal to the mean of the Elution Shift of each chromatographic peak.
}
\details{
This function repurposed from TargetedMSQC. Toghi Eshghi, S., Auger, P., & Mathews, W. R. (2018). Quality assessment and
interference detection in targeted mass spectrometry data using machine learning. Clinical Proteomics, 15.
https://doi.org/10.1186/s12014-018-9209-x
}
\examples{
# Calculate Elution Shift for each peak
data(ex_ptsList)
data(ex_peakDataList)
elutionShift <- calculateElutionShift(peakDataList = ex_peakDataList, ptsList = ex_ptsList)

}
