% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_sparse_zeros}
\alias{remove_sparse_zeros}
\title{Remove Zeros from a Sparse Matrix or Sparse Vector}
\usage{
remove_sparse_zeros(X, na.rm = FALSE)
}
\arguments{
\item{X}{A sparse matrix (COO, CSR, CSC) or sparse vector (any type)
from the `Matrix` package, whose values will be removed (left as non-present in the
sparse representation) if they are zeros.}

\item{na.rm}{Whether to also remove missing values (`NA` / `NaN`) from `X`.}
}
\value{
The same matrix / vector X with its zeros removed from the sparse representation.
}
\description{
Removes the entries in a sparse matrix or sparse vector which
have a value of zero but nevertheless are still among the object's values,
in any case there are any. Can also remove missing values if desired.
}
