% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csr_linalg.R
\name{csr-linalg}
\alias{csr-linalg}
\alias{norm,RsparseMatrix,character-method}
\alias{norm,RsparseMatrix,missing-method}
\alias{diag,RsparseMatrix-method}
\alias{diag<-,RsparseMatrix-method}
\title{Linear Algebra functions for CSR matrices}
\usage{
\S4method{norm}{RsparseMatrix,character}(x, type = "O", ...)

\S4method{norm}{RsparseMatrix,missing}(x, type = "O", ...)

\S4method{diag}{RsparseMatrix}(x)

\S4method{diag}{RsparseMatrix}(x) <- value
}
\arguments{
\item{x}{A sparse matrix in CSR format.}

\item{type}{Type of the norm to calculate (see \link[Matrix]{norm}).}

\item{...}{Extra arguments to pass to `norm`}

\item{value}{Replacement value for the matrix diagonal.}
}
\value{
The same value that `Matrix` would return for CSC matrices.
}
\description{
Short wrappers around some linear algebra operators from `Matrix`
that take CSC matrices, adapted to work for CSR matrices without involving any
data duplication or deep format conversion, thus saving time and memory.
}
