% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricinfo.R
\name{metricinfo}
\alias{metricinfo}
\title{Display Performance Metric Information}
\usage{
metricinfo(...)
}
\arguments{
\item{...}{\link[=metrics]{metric} functions or function names;
\link[=response]{observed responses}; \link[=response]{observed} and
\link[=predict]{predicted} responses; \link{confusion} or \link{resample}
results for which to display information.  If none are specified, information
is returned on all available metrics by default.}
}
\value{
List of named metric elements each containing the following
components:
\describe{
  \item{label}{character descriptor for the metric.}
  \item{maximize}{logical indicating whether higher values of the metric
    correspond to better predictive performance.}
  \item{arguments}{closure with the argument names and corresponding default
    values of the metric function.}
  \item{response_types}{data frame of the observed and predicted response
    variable types supported by the metric.}
}
}
\description{
Display information about metrics provided by the \pkg{MachineShop} package.
}
\examples{
## All metrics
metricinfo()

## Metrics by observed and predicted response types
names(metricinfo(factor(0)))
names(metricinfo(factor(0), factor(0)))
names(metricinfo(factor(0), matrix(0)))
names(metricinfo(factor(0), numeric(0)))

## Metric-specific information
metricinfo(auc)

}
