% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainedModels.R
\name{SelectedModel}
\alias{SelectedModel}
\title{Selected Model}
\usage{
SelectedModel(
  ...,
  control = MachineShop::settings("control"),
  metrics = NULL,
  cutoff = MachineShop::settings("cutoff"),
  stat = MachineShop::settings("stat.TrainingParams")
)
}
\arguments{
\item{...}{\link[=models]{model} functions, function names, objects; other
objects that can be \link[=as.MLModel]{coerced} to models; or vectors of
these to serve as the candidate set from which to select, such as that
returned by \code{\link{expand_model}}.}

\item{control}{\link[=controls]{control} function, function name, or object
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Model
selection is based on the first calculated metric.}

\item{cutoff}{argument passed to the \code{metrics} functions.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for model selection.}
}
\value{
\code{SelectedModel} class object that inherits from \code{MLModel}.
}
\description{
Model selection from a candidate set.
}
\details{
\describe{
  \item{Response types:}{\code{factor}, \code{numeric}, \code{ordered},
    \code{Surv}}
}
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm and glmnet to run

model_fit <- fit(
  sale_amount ~ ., data = ICHomes,
  model = SelectedModel(GBMModel, GLMNetModel, SVMRadialModel)
)
(selected_model <- as.MLModel(model_fit))
summary(selected_model)
}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
