% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLControl.R
\name{set_monitor}
\alias{set_monitor}
\title{Resampling Monitoring Control}
\usage{
set_monitor(control, progress = TRUE, verbose = FALSE)
}
\arguments{
\item{control}{\link[=controls]{control} object.}

\item{progress}{logical indicating whether to display a progress bar during
resampling if a computing cluster is not registered or is registered with
the \pkg{doSNOW} package.}

\item{verbose}{logical indicating whether to enable verbose messages which
may be useful for trouble shooting.}
}
\value{
Argument \code{control} updated with the supplied parameters.
}
\description{
Set parameters that control the monitoring of resample estimation of model
performance.
}
\examples{
CVControl() \%>\% set_monitor(verbose = TRUE)

}
\seealso{
\code{\link{set_predict}}, \code{\link{set_strata}},
\code{\link{resample}}, \code{\link{SelectedInput}},
\code{\link{SelectedModel}}, \code{\link{TunedInput}},
\code{\link{TunedModel}}
}
