% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_RFSRCModel.R
\name{RFSRCModel}
\alias{RFSRCModel}
\alias{RFSRCFastModel}
\title{Fast Random Forest (SRC) Model}
\usage{
RFSRCModel(
  ntree = 1000,
  mtry = NULL,
  nodesize = NULL,
  nodedepth = NULL,
  splitrule = NULL,
  nsplit = 10,
  block.size = NULL,
  samptype = c("swor", "swr"),
  membership = FALSE,
  sampsize = if (samptype == "swor") function(x) 0.632 * x else function(x) x,
  nimpute = 1,
  ntime = NULL,
  proximity = c(FALSE, TRUE, "inbag", "oob", "all"),
  distance = c(FALSE, TRUE, "inbag", "oob", "all"),
  forest.wt = c(FALSE, TRUE, "inbag", "oob", "all"),
  xvar.wt = NULL,
  split.wt = NULL,
  var.used = c(FALSE, "all.trees", "by.tree"),
  split.depth = c(FALSE, "all.trees", "by.tree"),
  do.trace = FALSE,
  statistics = FALSE
)

RFSRCFastModel(
  ntree = 500,
  sampsize = function(x) min(0.632 * x, max(150, x^0.75)),
  ntime = 50,
  terminal.qualts = FALSE,
  ...
)
}
\arguments{
\item{ntree}{number of trees.}

\item{mtry}{number of variables randomly selected as candidates for splitting
a node.}

\item{nodesize}{forest average number of unique cases in a terminal node.}

\item{nodedepth}{maximum depth to which a tree should be grown.}

\item{splitrule}{splitting rule (see \code{\link[randomForestSRC]{rfsrc}}).}

\item{nsplit}{non-negative integer value for number of random splits to
consider for each candidate splitting variable.}

\item{block.size}{interval number of trees at which to compute the cumulative
error rate.}

\item{samptype}{whether bootstrap sampling is with or without replacement.}

\item{membership}{logical indicating whether to return terminal node
membership.}

\item{sampsize}{function specifying the bootstrap size.}

\item{nimpute}{number of iterations of the missing data imputation algorithm.}

\item{ntime}{integer number of time points to constrain ensemble calculations
for survival outcomes.}

\item{proximity}{whether and how to return proximity of cases as measured by
the frequency of sharing the same terminal nodes.}

\item{distance}{whether and how to return distance between cases as measured
by the ratio of the sum of edges from each case to the root node.}

\item{forest.wt}{whether and how to return the forest weight matrix.}

\item{xvar.wt}{vector of non-negative weights representing the probability of
selecting a variable for splitting.}

\item{split.wt}{vector of non-negative weights used for multiplying the split
statistic for a variable.}

\item{var.used}{whether and how to return variables used for splitting.}

\item{split.depth}{whether and how to return minimal depth for each variable.}

\item{do.trace}{number of seconds between updates to the user on approximate
time to completion.}

\item{statistics}{logical indicating whether to return split statistics.}

\item{terminal.qualts}{logical indicating whether to return terminal node
membership information.}

\item{...}{arguments passed to \code{RFSRCModel}.}
}
\value{
\code{MLModel} class object.
}
\description{
Fast OpenMP computing of Breiman's random forest for a variety of data
settings including right-censored survival, regression, and classification.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{matrix}, \code{numeric},
    \code{Surv}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{mtry}, \code{nodesize}
  }
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.

In calls to \code{\link{varimp}} for \code{RFSRCModel}, argument
\code{type} may be specified as \code{"permute"} (default) for permutation of
OOB cases, as \code{"random"} for permutation replaced with random
assignment, or as \code{"anit"} for cases assigned to the split opposite of
the random assignments.  Variable importance is automatically scaled to range
from 0 to 100.  To obtain unscaled importance values, set
\code{scale = FALSE}.  See example below.
}
\examples{
\donttest{
## Requires prior installation of suggested package randomForestSRC to run

model_fit <- fit(sale_amount ~ ., data = ICHomes, model = RFSRCModel)
varimp(model_fit, type = "random", scale = TRUE)
}

}
\seealso{
\code{\link[randomForestSRC]{rfsrc}},
\code{\link[randomForestSRC]{rfsrc.fast}}, \code{\link{fit}},
\code{\link{resample}}
}
