% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\alias{response.formula}
\alias{response.recipe}
\title{Extract Response Variable}
\usage{
response(object, ...)

\method{response}{formula}(object, data, ...)

\method{response}{recipe}(object, data, ...)
}
\arguments{
\item{object}{object containing response variable values.}

\item{...}{arguments passed to other methods.}

\item{data}{\code{data.frame} containing the values of a response variable
defined in a formula.}
}
\description{
Extract the response variable from an object.
}
\examples{
## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
response(fo, data = Melanoma)

}
\seealso{
\code{\link[recipes]{recipe}}
}
