% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelmetrics.R
\docType{methods}
\name{modelmetrics}
\alias{modelmetrics}
\alias{modelmetrics,factor,factor-method}
\alias{modelmetrics,factor,matrix-method}
\alias{modelmetrics,factor,numeric-method}
\alias{modelmetrics,matrix,matrix-method}
\alias{modelmetrics,numeric,numeric-method}
\alias{modelmetrics,Surv,matrix-method}
\alias{modelmetrics,Surv,numeric-method}
\title{Model Performance Metrices}
\usage{
modelmetrics(observed, predicted, ...)

\S4method{modelmetrics}{factor,factor}(observed, predicted, ...)

\S4method{modelmetrics}{factor,matrix}(observed, predicted, ...)

\S4method{modelmetrics}{factor,numeric}(observed, predicted,
  cutoff = 0.5, cutoff_index = function(sens, spec) sens + spec, ...)

\S4method{modelmetrics}{matrix,matrix}(observed, predicted, ...)

\S4method{modelmetrics}{numeric,numeric}(observed, predicted, ...)

\S4method{modelmetrics}{Surv,matrix}(observed, predicted, times, ...)

\S4method{modelmetrics}{Surv,numeric}(observed, predicted, ...)
}
\arguments{
\item{observed}{vector of observed responses.}

\item{predicted}{model-predicted responses.}

\item{...}{arguments passed to or from other methods.}

\item{cutoff}{threshold above which probabilities are classified as success.}

\item{cutoff_index}{function to calculate a desired sensitivity-specificity
tradeoff.}

\item{times}{numeric vector of follow-up times at which survival events
were predicted.}
}
\description{
Compute measures of model performance.
}
\examples{
## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
gbmfit <- fit(fo, data = Melanoma, model = GBMModel)

obs <- response(fo, data = Melanoma)
pred <- predict(gbmfit, newdata = Melanoma, type = "prob")
modelmetrics(obs, pred)

}
\seealso{
\code{\link{predict}}, \code{\linkS4class{MLControl}}
}
