% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CREARBS.R
\name{CREA.RBS}
\alias{CREA.RBS}
\title{An expert rule based system using Reduction Based on Significance}
\arguments{
\item{formula}{a formula of the form y ~ x1 + x2 + ...}

\item{data}{the data frame that contains the variables specified in \code{formula}.}
}
\value{
A MLA object of subclass CREA-RBS
}
\description{
CREA-RBS is a rule reduction method for allocating a significance value to each rule in the system so that experts
may select the rules that should be considered as preferable and understand the exact degree of correlation between the different
rule attributes.
}
\details{
Significance is calculated from the antecedent frequency and rule frequency parameters for each rule; if the first
one is above the minimal level and rule frequency is in a critical interval, its significance ratio is computed by the algorithm.
These critical boundaries are calculated by an incremental method and the rule space is divided according to them.
The significance function is defined for these intervals.
}
\examples{
## Load a Dataset
data(EGATUR)
## Generate a CREA-RBS model, remmember only support discretized variables
CREA.RBS(GastoTotalD~pais+aloja+motivo,data=EGATUR)



}
\references{
Almiñana, M., Escudero, L. F., Pérez-Martín, A., Rabasa, A., & Santamaría, L. (2014). A classification rule reduction algorithm based on significance domains. Top, 22(1), 397-418.
}
