\name{Cor.Mat.MM}
\alias{Cor.Mat.MM}
\docType{data}
\title{ Correlation matrix for Maruyama \& McGarvey (1980) data set
}

\description{
Correlation matrix for Maruyama \& McGarvey (1980) data set
}

\usage{data(Cor.Mat.MM)}

%\format{}

\details{
Variables 1 through 13 in the correlation matrix are, respectively: 

\tabular{l}{
Variables \cr
(1) seating popularity \cr
(2) playground popularity\cr
(3) schoolwork popularity\cr
(4) verbal achievement\cr
(5) verbal grades \cr
(6) Duncan SEI \cr
(7) education of head of house\cr
(8) No. of rooms over No. of persons \cr
(9) Raven Progressive Matrices \cr
(10) Peabody PVT \cr
(11) father's evaluation \cr
(12) mothers evaluation \cr
(13) teacher's evaluation
}

The model was designed to examin whether acceptance by significant others (i.e., parents, teachers, and peers)
causes improved scholastic achievement. There are five latent variables in the model: (a) SES, socio-economic
status; (b) ABL, academic ability; (c) ACH, achievement; (d) ASA, acceptance by significant adults; (e) APR,
acceptance by peers. 

SES is indicated by (a) SEI, Duncan Socioeconomic Index of Occupations; (b) EDHH, educational attainment of
the head of the household; (c) R/P, ratio of rooms in the house to persons living in the house.

ACH is indicated by (a) VACH, standardized verbal test scores; (b) VGR, verbal grades.

ABL is indicated by (a) PEA, Peabody Picture Vocabulary Test; (b) RAV, Raven Progressive Matrices.

ASA is indicated by (a) FEV, father's evaluation; (b) MEV, mother's evaluation; (c) TEV, teacher's evaluation.

APR is indicated by (a) PPOP, playground popularity; (b) SPOP, seating popularity; (c) WPOP, schoolwork popularity.
}
\source{
Maruyama, G., & McGarvey, B. (1980). Evaluating causal models: An application of maximum-likelihood analysis
of structural equations. \emph{Psychological Bulletin, 87} (3), 502-512.
}
\references{
Maruyama, G., & McGarvey, B. (1980). Evaluating causal models: An application of maximum-likelihood analysis
of structural equations. \emph{Psychological Bulletin, 87} (3), 502-512.
}
%\examples{}
\keyword{datasets}
