% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logicopt.R
\name{print_multi_tt}
\alias{print_multi_tt}
\title{Print logicopt() results}
\usage{
print_multi_tt(esp_multi, eqn = FALSE, n_in, n_out, max_sol = 50,
  QCA = FALSE)
}
\arguments{
\item{esp_multi}{An R data frame table representing a truth table with 1 or more 
solutions.}

\item{eqn}{Print in equation format.  Default is FALSE.}

\item{n_in}{Number of inputs in the esp_multi truth table.}

\item{n_out}{Number of outputs in the esp_multi truth table.}

\item{max_sol}{Maximum number of solutions to print.  Default is 50.}

\item{QCA}{Attempt to print out in a QCA like format}
}
\value{
None
}
\description{
This function prints the the results from logicopt()
in truth table or equation format.
}
\examples{
data(l.partybans.0)
tt <- logicopt(l.partybans.0,n_in=5,n_out=1,find_dc=TRUE,mode="multi-full")
print_multi_tt(tt,5,1,eqn=TRUE,max_sol=5) 

}

