% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.typed.permute}
\alias{get.tau.typed.permute}
\title{get the null distribution for the \code{get.tau.typed} function}
\usage{
get.tau.typed.permute(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), permutations,
  comparison.type = "representative")
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{comparison.type}{what type of points are included in the comparison set.
\itemize{
  \item "representative" if comparison set is representative of the underlying population
  \item "independent" if comparison set is cases/events coming from an indepedent process
}}
}
\value{
a matrix with permutation tau values for each distance specified
}
\description{
get the null distribution for the \code{get.tau.typed} function
}
\examples{
\dontrun{
R/examples/get_tau_typed_permute.R
}

}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}},
  \code{\link{get.tau.ci}}, \code{\link{get.tau.permute}},
  \code{\link{get.tau.typed.bootstrap}},
  \code{\link{get.tau.typed}}, \code{\link{get.tau}}
}

