% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{mk_event_individual}
\alias{mk_event_individual}
\title{Creates an event with intensity of class individual.}
\usage{
mk_event_individual(type, name, intensity_code, kernel_code = "")
}
\arguments{
\item{type}{Must be one of \code{'birth'}, \code{'death'}, \code{'entry'}, \code{'exit'}, \code{'swap'} or \code{'custom'}. See details.}

\item{name}{\emph{(Optional)} If not specified, the name given to the event is its type.}

\item{intensity_code}{String containing some C++ code describing the intensity function. See details.}

\item{kernel_code}{String containing some C++ code describing the event action. Optional for \code{'birth'}, \code{'death'} and \code{'exit'} events. See details.}
}
\value{
An S3 object of class \code{event} of type individual.
}
\description{
Creates an event with intensity of class individual (without interactions). When the event occurs, something happens to an individual \code{I} in the population.
The created event must be used with \code{\link{mk_model}}.
}
\details{
The \code{type} argument is one of the following
\describe{
\item{\code{'birth'}}{By default, a new individual \code{newI} is created, with the same characteristics of the parent \code{I} and birth date equal to the current time. Optional code can be precised in \code{kernel_code}.}
\item{\code{'death'}}{By default, the individual \code{I} dies. Optional code can be precised in \code{kernel_code}.}
\item{\code{'entry'}}{A new individual \code{newI} is added to the population, and its characteristics have to be defined by the user in the entry \code{kernel_code}.}
\item{\code{'exit'}}{An individual \code{I} exits from the population. Optional code can be precised in \code{kernel_code}.}
\item{\code{'swap'}}{The user can change the characteristics of the selected individual \code{I}. This requires \code{kernel_code}.}
\item{\code{'custom'}}{None of the above types, the user defines \code{kernel_code} that can act on the selected individual \code{I} and on the population \code{pop}.}
}

The \code{intensity_code} argument is a string containing some C++ code describing the event intensity for individual \code{I} at time \code{t}. The intensity value \strong{must be stored} in the variable \code{result}.
Some of available variables in the C++ code are: \code{t} (the current time), \code{I} (the current individual selected for the event), the name of the model parameters (some variables, or functions, see \code{\link{mk_model}}).
See \code{vignette('IBMPopSim_Cpp')} for more details.

The \code{kernel_code} argument is a string containing some C++ code which describing the action of the event. Some of available variables in the C++ code are: \code{t} (the current time), \code{pop} (the current population), \code{I} (the current individual selected for the event), \code{newI} (the new individual if \code{'birth'} or \code{'entry'} event), the name of the model parameters (some variables, or functions, see \code{\link{mk_model}}).
See \code{vignette('IBMPopSim')} for more details.
}
\examples{
params <- list("p_male"= 0.51,
              "birth_rate" = stepfun(c(15,40), c(0,0.05,0)),
              "death_rate" = gompertz(0.008, 0.02))

death_event <- mk_event_individual(type = "death",
                name = "my_death_event",
                intensity_code = "result = death_rate(age(I,t));")

birth_event <- mk_event_individual(type = "birth",
                intensity_code = "if (I.male) result = 0;
                                  else result = birth_rate(age(I,t));",
                kernel_code = "newI.male = CUnif(0, 1) < p_male;")
         
}
\seealso{
\code{\link{mk_model}}, \code{\link{mk_event_poisson}}, \code{\link{mk_event_inhomogeneous_poisson}}, and \code{\link{mk_event_interaction}}.
}
