/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class StringUtilities {
    public static final int ELLIPSIS_LENGTH_LONG = 2000;
    public static final int ELLIPSIS_LENGTH_SHORT = 400;
    public static String PREFERENCES_DIRECTORY = ".ptolemyII";

    private StringUtilities() {
    }

    public static String abbreviate(String longName) {
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        return longName.substring(0, 37) + ". . ." + longName.substring(longName.length() - 38);
    }

    public static String ellipsis(String string, int length) {
        StringTokenizer tokenizer = new StringTokenizer(string = StringUtilities.split(string), "\n", true);
        if (tokenizer.countTokens() > 20) {
            StringBuffer results = new StringBuffer();
            int i = 0;
            while (i < 20 && tokenizer.hasMoreTokens()) {
                results.append(tokenizer.nextToken());
                ++i;
            }
            results.append("...");
            return results.toString();
        }
        if (string.length() > length) {
            return string.substring(0, length - 3) + "...";
        }
        return string;
    }

    public static String escapeForXML(String string) {
        string = StringUtilities.substitute(string, "&", "&amp;");
        string = StringUtilities.substitute(string, "\"", "&quot;");
        string = StringUtilities.substitute(string, "<", "&lt;");
        string = StringUtilities.substitute(string, ">", "&gt;");
        string = StringUtilities.substitute(string, "\n", "&#10;");
        return string;
    }

    public static String getIndentPrefix(int level) {
        if (level <= 0) {
            return "";
        }
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < level) {
            result.append("    ");
            ++i;
        }
        return result.toString();
    }

    public static String preferencesDirectory() throws IOException {
        String preferencesDirectoryName = StringUtilities.getProperty("user.home") + StringUtilities.getProperty("file.separator") + PREFERENCES_DIRECTORY + StringUtilities.getProperty("file.separator");
        File preferencesDirectory = new File(preferencesDirectoryName);
        if (!preferencesDirectory.isDirectory() && !preferencesDirectory.mkdirs()) {
            throw new IOException("Could not create user preferences directory '" + preferencesDirectoryName + "'");
        }
        return preferencesDirectoryName;
    }

    public static String getProperty(String propertyName) {
        String property;
        block19: {
            property = null;
            try {
                property = System.getProperty(propertyName);
            }
            catch (SecurityException security) {
                if (propertyName.equals("ptolemy.ptII.dir")) break block19;
                throw new RuntimeException("Could not find '" + propertyName + "' System property", security);
            }
        }
        if (propertyName.equals("user.dir")) {
            try {
                File userDirFile = new File(property);
                return userDirFile.getCanonicalPath();
            }
            catch (IOException ex) {
                return property;
            }
        }
        if (property != null) {
            return property;
        }
        if (propertyName.equals("ptolemy.ptII.dirAsURL")) {
            File ptIIAsFile = new File(StringUtilities.getProperty("ptolemy.ptII.dir"));
            try {
                URL ptIIAsURL = ptIIAsFile.toURL();
                return ptIIAsURL.toString();
            }
            catch (MalformedURLException malformed) {
                throw new RuntimeException("While trying to find '" + propertyName + "', could not convert '" + ptIIAsFile + "' to a URL", malformed);
            }
        }
        if (propertyName.equals("ptolemy.ptII.dir")) {
            String namedObjPath = "ptolemy/kernel/util/NamedObj.class";
            String home = null;
            URL namedObjURL = Thread.currentThread().getContextClassLoader().getResource(namedObjPath);
            if (namedObjURL != null) {
                String ptsupportJarName;
                String abnormalHome;
                String namedObjFileName = namedObjURL.getFile().toString();
                if (namedObjFileName.startsWith("file:")) {
                    namedObjFileName = namedObjFileName.substring(6);
                }
                if ((home = new File(abnormalHome = namedObjFileName.substring(0, namedObjFileName.length() - namedObjPath.length())).toString()).endsWith("!")) {
                    home = home.substring(0, home.length() - 1);
                }
                if (home.endsWith(ptsupportJarName = File.separator + "DMptolemy" + File.separator + "RMptsupport.jar")) {
                    home = home.substring(0, home.length() - ptsupportJarName.length());
                }
                if (home.endsWith(ptsupportJarName = File.separator + "ptolemy" + File.separator + "ptsupport.jar")) {
                    home = home.substring(0, home.length() - ptsupportJarName.length());
                }
            }
            if (home == null) {
                throw new RuntimeException("Could not find 'ptolemy.ptII.dir' property.  Also tried loading '" + namedObjPath + "' as a resource and working from that. " + "Vergil should be " + "invoked with -Dptolemy.ptII.dir" + "=\"$PTII\"");
            }
            try {
                System.setProperty("ptolemy.ptII.dir", home);
            }
            catch (SecurityException security) {
                // empty catch block
            }
            return home;
        }
        if (property == null) {
            return "";
        }
        return property;
    }

    public static String sanitizeName(String name) {
        char[] nameArray = name.toCharArray();
        int i = 0;
        while (i < nameArray.length) {
            if (!Character.isJavaIdentifierPart(nameArray[i])) {
                nameArray[i] = 95;
            }
            ++i;
        }
        if (!Character.isJavaIdentifierStart(nameArray[0])) {
            return "_" + new String(nameArray);
        }
        return new String(nameArray);
    }

    public static String split(String longName) {
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        StringBuffer results = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(longName, "\r\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int i = 0;
            while (i < token.length() - 79) {
                int lastSpaceIndex = token.substring(i, i + 79).lastIndexOf(" ");
                if (lastSpaceIndex < 0) {
                    results.append(token.substring(i, i + 79) + "\n");
                    i += 79;
                    continue;
                }
                results.append(token.substring(i, i + lastSpaceIndex) + "\n");
                i += lastSpaceIndex + 1;
            }
            results.append(token.substring(i));
        }
        return results.toString();
    }

    public static String substitute(String string, String pattern, String replacement) {
        int start = string.indexOf(pattern);
        while (start != -1) {
            StringBuffer buffer = new StringBuffer(string);
            buffer.delete(start, start + pattern.length());
            buffer.insert(start, replacement);
            string = new String(buffer);
            start = string.indexOf(pattern, start + replacement.length());
        }
        return string;
    }

    public static String[] tokenizeForExec(String inputString) throws IOException {
        LinkedList<String> commandList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(inputString));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String token = "";
        String singleToken = "";
        boolean inDoubleQuotedString = false;
        block6: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (inDoubleQuotedString) {
                        if (token.length() > 0) {
                            token = token + " ";
                        }
                        token = token + singleToken + streamTokenizer.sval;
                    } else {
                        token = singleToken + streamTokenizer.sval;
                        commandList.add(token);
                    }
                    singleToken = "";
                    break;
                }
                case -2: {
                    throw new RuntimeException("Internal error: Found TT_NUMBER: '" + streamTokenizer.nval + "'.  We should not be " + "tokenizing numbers");
                }
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    singleToken = new Character((char)streamTokenizer.ttype).toString();
                    if (!singleToken.equals("\"")) continue block6;
                    if (inDoubleQuotedString) {
                        commandList.add(token);
                    }
                    inDoubleQuotedString = !inDoubleQuotedString;
                    singleToken = "";
                    token = "";
                }
            }
        }
        return commandList.toArray(new String[commandList.size()]);
    }

    public static String usageString(String commandTemplate, String[][] commandOptions, String[] commandFlags) {
        String result = "Usage: " + commandTemplate + "\n\n" + "Options that take values:\n";
        int i = 0;
        while (i < commandOptions.length) {
            result = result + " " + commandOptions[i][0] + " " + commandOptions[i][1] + "\n";
            ++i;
        }
        result = result + "\nBoolean flags:\n";
        i = 0;
        while (i < commandFlags.length) {
            result = result + " " + commandFlags[i];
            ++i;
        }
        return result;
    }
}

