/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.util.StringUtilities;

public class StreamExec {
    private List _commands = null;
    private Process _process;

    public void cancel() {
        this._process.destroy();
    }

    public void clear() {
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    public Process getProcess() {
        return this._process;
    }

    public static void main(String[] args) {
        LinkedList<String> execCommands = new LinkedList<String>();
        execCommands.add("date");
        execCommands.add("sleep 5");
        execCommands.add("date");
        execCommands.add("javac");
        StreamExec exec = new StreamExec();
        exec.setCommands(execCommands);
        exec.start();
    }

    public void setCommands(List commands) {
        this._commands = commands;
    }

    public void start() {
        String returnValue = this._executeCommands();
        this.updateStatusBar(returnValue);
        this.stdout(returnValue);
    }

    public void stderr(String text) {
        System.err.println(text);
        System.err.flush();
    }

    public void stdout(String text) {
        System.out.println(text);
        System.out.flush();
    }

    public void updateStatusBar(String text) {
    }

    protected void _setProgressBarMaximum(int size) {
    }

    private void _updateProgressBar(int i) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._setProgressBarMaximum(this._commands.size());
                int commandCount = 0;
                Iterator commands = this._commands.iterator();
                while (commands.hasNext()) {
                    this._updateProgressBar(++commandCount);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] commandTokens = StringUtilities.tokenizeForExec((String)commands.next());
                    this.stdout("About to execute:\n");
                    StringBuffer statusCommand = new StringBuffer();
                    int i = 0;
                    while (i < commandTokens.length) {
                        this.stdout("        " + commandTokens[i]);
                        if (statusCommand.length() < 50) {
                            if (statusCommand.length() > 0) {
                                statusCommand.append(" ");
                            }
                            statusCommand.append(commandTokens[i]);
                        }
                        ++i;
                    }
                    if (statusCommand.length() >= 50) {
                        statusCommand.append(" . . .");
                    }
                    this.updateStatusBar("Executing: " + statusCommand.toString());
                    this._process = runtime.exec(commandTokens);
                    _StreamReaderThread errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), "ERROR", this);
                    _StreamReaderThread outputGobbler = new _StreamReaderThread(this._process.getInputStream(), "OUTPUT", this);
                    errorGobbler.start();
                    outputGobbler.start();
                    try {
                        int processReturnCode = this._process.waitFor();
                        StreamExec streamExec = this;
                        synchronized (streamExec) {
                            this._process = null;
                        }
                        if (processReturnCode == 0) continue;
                        break;
                    }
                    catch (InterruptedException interrupted) {
                        this.stderr("InterruptedException: " + interrupted);
                        throw interrupted;
                    }
                }
            }
            catch (IOException io) {
                this.stderr("IOException: " + io);
            }
        }
        catch (InterruptedException e) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
        return "All Done";
    }

    private class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private String _streamType;
        private StreamExec _streamExec;

        _StreamReaderThread(InputStream inputStream, String streamType, StreamExec streamExec) {
            this._inputStream = inputStream;
            this._streamType = streamType;
            this._streamExec = streamExec;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    this._streamExec.stdout(line);
                }
            }
            catch (IOException ioe) {
                this._streamExec.stderr("IOException: " + ioe);
            }
        }
    }
}

