% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casting.R
\name{as.GeneralTree.data.frame}
\alias{as.GeneralTree.data.frame}
\title{Convert a data frame to a GeneralTree.}
\usage{
\method{as.GeneralTree}{data.frame}(x, ...)
}
\arguments{
\item{x}{The data frame that should be converted to a tree.}

\item{...}{id      The column name of the column that holds the ids of each node.
data    The column name of the column that holds the data of
        each node.
parent  The column name of the column that holds the parent
        of each node, NA indicates a node is the root.}
}
\description{
Convert a data frame to a GeneralTree.
}
\examples{
  test_tree_df <- data.frame(
      ID = c("root", "child1", "child2", "child3"),
      DATA = c("parent1", "data3.1", "data1.2", "data1.3"),
     PARENT = c(NA, "child3", "root", "root"), stringsAsFactors = FALSE)
as.GeneralTree(test_tree_df, id = "ID", data = "DATA", parent = "PARENT")

}

