\name{aliquot}
\alias{aliquot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate the Aliquot sequence.
}
\description{
Each term in the aliquot sequence is generated by summing all proper divisors of the previous term. The value "1" is included in this collection of divisors. 
In number theory, aliquot is closely related to terms such as "sociable" and "amicable" numbers
}
\usage{
aliquot(x, maxiter = 100)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
An integer or a \code{bigz} integer to start the desired sequence
}
  \item{maxiter}{
Set a limit on the number of terms to calculate. See Details for reasons why to do so. 
}
}
\details{
While many aliquot sequences terminate in the values c(prime_number, 1, 0), many numbers drop into a short loop or a repeating value (perfect numbers do this).  If the sequence repeats or terminates, the sequence is returned. If either \code{maxiter} is reached or the sequence drops into a loop (and thus \code{maxiter} will be triggered), a warning notice is generated and the sequence so far is returned. 
}
\value{
A vector of \code{bigz} integers ...
}

\author{
Carl Witthoft,  \email{carl@witthoft.com} 
%%  ~~who you are~~
}


\examples{
aliquot(20)
# 20 22 14 10 8  7  1
aliquot (95)
# repeats '6' forever
# 95 25 6  6
}
