% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_delta.R
\name{find_best_delta}
\alias{find_best_delta}
\title{Functional Cheng and Church Algorithm varying the delta value}
\usage{
find_best_delta(
  fun_mat,
  delta_min,
  delta_max,
  num_delta = 10,
  template.type = "mean",
  theta = 1.5,
  number = 100,
  alpha = 0,
  beta = 0,
  const_alpha = FALSE,
  const_beta = FALSE,
  shift.alignement = FALSE,
  shift.max = 0.1,
  max.iter.align = 100
)
}
\arguments{
\item{fun_mat}{The data array (n x m x T) where each entry corresponds to the measure of one observation i, i=1,...,n, for a functional variable m, m=1,...,p, at point t, t=1,...,T}

\item{delta_min}{scalar: Manimum value of the maximum of accepted score, should be a real value > 0}

\item{delta_max}{scalar: Maximum value of the maximum of accepted score, should be a real value > 0}

\item{num_delta}{integer: number of delta to be evaluated between delta_min and delta_max}

\item{template.type}{character: type of template required. If template.type='mean' the template is evaluated as the average function, if template.type='medoid' the template is evaluated as the medoid function.}

\item{theta}{scalar: Scaling factor should be a real value > 1}

\item{number}{integer: Maximum number of iterations}

\item{alpha}{binary: if alpha=1 row shift is allowed, if alpha=0 row shift is avoided}

\item{beta}{binary: if beta=1 row shift is allowed, if beta=0 row shift is avoided}

\item{const_alpha}{logicol: indicates if row shift is contrained as constant}

\item{const_beta}{logicol: indicates if col shift is contrained as constant}

\item{shift.alignement}{logicol: If shift.alignement=True the shift aligment is performed, if shift.alignement=False no alignment is performed}

\item{shift.max}{scalar: shift.max controls the maximal allowed shift, at each iteration, in the alignment procedure with respect to the range of curve domains. t.max must be such that 0<shift.max<1}

\item{max.iter.align}{integer: maximum number of iteration in the alignment procedure}
}
\value{
a dataframe containing for each evaluated delta: Htot_sum (the sum of totale H-score), num_clust (the number of found Bi-clusters), not_assigned (the number of not assigned elements)
}
\description{
The find_best_delta function evaluate the results of FunCC algorithm in terms of total H-score value, the number of obtained bi-clusters and the number of not assigned elements when varying the delta value
}
\examples{
\dontrun{ 
data("funCCdata")
find_best_delta(funCCdata,delta_min=0.1,delta_max=20,num_delta=20,alpha=1,beta=0,const_alpha=TRUE)
}
}
