% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{subsample.fossils.oldest.and.youngest}
\alias{subsample.fossils.oldest.and.youngest}
\title{Obtain a subsample of fossil occurrences containing the oldest and youngest
fossil sample found at each node of the tree.}
\usage{
subsample.fossils.oldest.and.youngest(fossils, tree, complete = TRUE)
}
\arguments{
\item{fossils}{an object of class "fossils" that corresponds to fossil
occurrences.}

\item{tree}{an object of class "Phylo", representing the tree upon which the
fossil occurrences were simulated.}

\item{complete}{logical, if TRUE the oldest and youngest sample from each
clade in the complete tree is returned, if FALSE the oldest and youngest
sample from each clade in the extant only counterpart tree is returned.}
}
\value{
an object of class "fossils" containing the subsampled fossil
  occurrences.
}
\description{
Obtain a subsample of fossil occurrences containing the oldest and youngest
fossil sample found at each node of the tree.
}
\examples{
t = TreeSim::sim.bd.taxa(10, 1, 0.1, 0.05)[[1]]
f = sim.fossils.poisson(0.1, t, root.edge = FALSE)
subsample.fossils.oldest.and.youngest(f, t, complete = FALSE)
}
