% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05.1.graph_methods.R
\name{graph_methods}
\alias{graph_methods}
\alias{V}
\alias{vcount}
\alias{gorder}
\alias{E}
\alias{ecount}
\alias{gsize}
\alias{plot_igraph}
\title{Extending \code{igraph} functions to \code{igraph_financial} objects}
\usage{
V(x)

vcount(x)

gorder(x)

E(x, ...)

ecount(x, ...)

gsize(x, ...)

plot_igraph(x, ...)
}
\arguments{
\item{x}{The \code{igraph_financial} object}

\item{...}{Other parameters passed to the corresponding \code{igraph} functions (see Details).}
}
\value{
The same result for both \code{igraph} and {igraph_financial} objects
\itemize{
 \item \code{V}: A vertex sequence containing all vertices, in the order of their numeric vertex ids.
 \item \code{vcount} and \code{gorder}: Number of vertices, numeric scalar.
 \item \code{E}: An edge sequence of the graph
 \item \code{ecount} and \code{gsize}: Number of edges, numeric scalar.
 \item \code{plot_igraph}: Returns NULL, invisibly. Called to print the graph to any R device. (see method and \href{https://rdrr.io/cran/igraph/man/plot.igraph.html}{igraph::plot.igraph})
}
}
\description{
The following functions are implemented:
\itemize{
 \item \code{V_fin} to retrieve the vertexes (\code{igraph::V});
 \item \code{vcount_fin} to count the vertexes (\code{igraph::vcount});
 \item \code{gorder_fin} as an alias to \code{vcount_fin} (\code{igraph::gorder});
 \item \code{E_fin} to retrieve the edges (\code{igraph::E});
 \item \code{gsize_fin} to count the edges (\code{igraph::gsize});
 \item \code{ecount_fin} as an alias to \code{gsize_fin} (\code{igraph::ecount})
 \item \code{plot_igraph_fin} to plot graphs (\code{igraph::plot.igraph}))
}
}
\details{
Implementing most basic iterators from the package \code{igraph} for objects of class \code{igraph_financial}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
