% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GHCN_FUNCTIONS.R
\name{get_ghcn_inventory}
\alias{get_ghcn_inventory}
\title{Download and crop the inventory of GHCN stations.}
\usage{
get_ghcn_inventory(template = NULL, elements = NULL, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{elements}{A character vector of elemets to extract.
Common elements include "tmin", "tmax", and "prcp".}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing.}
}
\value{
A \code{SpatialPolygonsDataFrame} of the GHCN stations within
the specified \code{template}
}
\description{
\code{get_ghcn_inventory} returns a \code{SpatialPolygonsDataFrame} of the GHCN stations within
the specified \code{template}. If template is not provided, returns the entire GHCN inventory.
}
\details{
Stations with multiple elements will have multiple points. This allows for easy mapping of stations
by element availability.
}

