% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCovariatesFromOtherCohorts.R
\name{createCohortBasedTemporalCovariateSettings}
\alias{createCohortBasedTemporalCovariateSettings}
\title{Create settings for temporal covariates based on other cohorts}
\usage{
createCohortBasedTemporalCovariateSettings(
  analysisId,
  covariateCohortDatabaseSchema = NULL,
  covariateCohortTable = NULL,
  covariateCohorts,
  valueType = "binary",
  temporalStartDays = -365:-1,
  temporalEndDays = -365:-1,
  includedCovariateIds = c(),
  warnOnAnalysisIdOverlap = TRUE
)
}
\arguments{
\item{analysisId}{A unique identifier for this analysis.}

\item{covariateCohortDatabaseSchema}{The database schema where the cohorts used to define the covariates
can be found. If set to \code{NULL}, the database schema will be
guessed, for example using the same one as for the main cohorts.}

\item{covariateCohortTable}{The table where the cohorts used to define the covariates
can be found. If set to \code{NULL}, the table will be
guessed, for example using the same one as for the main cohorts.}

\item{covariateCohorts}{A data frame with at least two columns: 'cohortId' and 'cohortName'. The
cohort  ID should correspond to the \code{cohort_definition_id} of the cohort
to use for creating a covariate.}

\item{valueType}{Either 'binary' or 'count'. When \code{valueType = 'count'}, the covariate
value will be the number of times the cohort was observed in the window.}

\item{temporalStartDays}{A list of integers representing the start of a time
period, relative to the index date. 0 indicates the
index date, -1 indicates the day before the index
date, etc. The start day is included in the time
period.}

\item{temporalEndDays}{A list of integers representing the end of a time
period, relative to the index date. 0 indicates the
index date, -1 indicates the day before the index
date, etc. The end day is included in the time
period.}

\item{includedCovariateIds}{A list of covariate IDs that should be restricted to.}

\item{warnOnAnalysisIdOverlap}{Warn if the provided `analysisId` overlaps with any predefined analysis as
available in the `createTemporalCovariateSettings()` function.}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create settings for temporal covariates based on other cohorts
}
\details{
Creates an object specifying temporal covariates to be constructed based on the presence of other cohorts.
}
