% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepro.R
\name{preprocess_data}
\alias{preprocess_data}
\title{Preprocess data}
\usage{
preprocess_data(
  data = read_rp_xlsx(),
  degree_polynomial = 1,
  interaction_terms = FALSE,
  verbose = 1,
  nw = 1
)
}
\arguments{
\item{data}{dataframe with columns RT, NAME, SMILES}

\item{degree_polynomial}{defines how many polynomials get added (if 3 quadratic and cubic terms get added)}

\item{interaction_terms}{if TRUE all interaction terms get added to data set}

\item{verbose}{0 == no output, 1 == show progress, 2 == show progress and warnings}

\item{nw}{number of workers to use for parallel processing}
}
\value{
A dataframe with the preprocessed data
}
\description{
Preprocess data so they can be used as input for \code{\link[=train_frm]{train_frm()}}.
}
\examples{
data <- head(RP, 3)
pre <- preprocess_data(data, verbose = 0)
}
\keyword{public}
