% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multest_options.R
\name{multest_options}
\alias{multest_options}
\title{Multest output options.}
\usage{
multest_options(
  multest_fmt = "csv",
  multest_outfolder = NULL,
  multest_dsn = NULL,
  multest_layer = NULL,
  multest.append = FALSE,
  multest.AOIonly = FALSE,
  ...
)
}
\arguments{
\item{multest_fmt}{String. Format for multest output tables ('csv',
'sqlite', 'gpkg').}

\item{multest_outfolder}{String. Outfolder for multest. If NULL, same as
outfolder.}

\item{multest_dsn}{String. Name of database if multest_fmt = c('sqlite',
'gpkg').}

\item{multest_layer}{String. Name of database layer if multest_fmt =
c('sqlite', 'gpkg').}

\item{multest.append}{Logical. If TRUE, appends multest dataframe to output.}

\item{multest.AOIonly}{Logical. If TRUE, appends multest dataframe (AOI=1)
to output.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for outputting
multest.
}
\description{
Returns a list of user-supplied parameters and parameter values for outputting
multest with custom aesthetics.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

multest_options(multest.append = TRUE)

}
\author{
Grayson W. White
}
\keyword{options}
