% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_file.split.R
\name{shape_file.split}
\alias{shape_file.split}
\title{Divide a imagem em objetos/parcelas de acordo com o shapefile}
\usage{
shape_file.split(im,shapefile,namesFile="test",path=getwd(),type="jpg")
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage/ExpImage.}

\item{shapefile}{Objeto criado pela funcao shape_file.create}

\item{namesFile}{Nome do arquivo a ser salvo.}

\item{path}{Endereco da pasta onde as imagens seram salvas.}

\item{type}{Extensao da imagem a ser salva.EX: jpg, png, tiff.}
}
\description{
Esta funcao divide a imagem em objetos/parcelas a partir do shapefile criado pela funcao
 shape_file.create. Dessa forma e criada uma imagem para cada objeto.
}
\examples{
\dontrun{
end=example_image(13)
im=read_image(end,plot=TRUE)
A=shape_file.create(im,rows=5,cols=5,rectangular=F,Matrix=NULL,SelectSeveral = F)
B=shape_file.BorderExtract(im,A,p.rows = .9,p.cols = .9)
shape_file.plot(im,ShapeFile = B)
shape_file.split(im =im,shapefile = B,path = getwd(),namesFile = "TEST",type = ".jpg")
}
}
\seealso{
\code{\link{shape_file.create}}, \code{\link{shape_file.split}}
}
