% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3D.R
\name{plot3D}
\alias{plot3D}
\title{Plotar graficos 3D}
\usage{
plot3D(Resultado,
              modelo=NULL,
              cor=NULL,
              xlab=NULL,
              ylab=NULL,
              zlab=NULL,
              main=NULL)
}
\arguments{
\item{Resultado}{Objeto do tipo list contendo a saida da funcao
'AjustarRegressao'}

\item{modelo}{Indica o modelo considerado na confeccao do grafico. Pode ser
NULL (default) ou um valor numerico de 1 a 12:
 \itemize{
\item NULL -> Considera o melhor dos 12 modelos testados de acordo com o
Criterio de informatividade de Akaike (AIC)
\item 1 -> O grafico e plotado considerando o modelo:
 Z~1+X+Y
\item 2 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y
\item 3 -> O grafico e plotado considerando o modelo:
Z~1+X+Y+I(Y^2)
\item 4 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)
\item 5 -> O grafico e plotado considerando o modelo:
Z~1+X+Y+X:Y
\item 6 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+X:Y
\item 7 -> O grafico e plotado considerando o modelo:
Z~1+X+Y+I(Y^2)+X:Y
\item 8 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)+X:Y
\item 9 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)+X:Y+I(X^2):Y
\item 10 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)+X:Y+I(Y^2):X
\item 11 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)+X:Y+I(X^2):Y+I(Y^2):X
\item 12 -> O grafico e plotado considerando o modelo:
Z~1+X+I(X^2)+Y+I(Y^2)+X:Y+I(X^2):Y+I(Y^2):X+I(X^2):I(Y^2))
}}

\item{cor}{Refere-se a paleta de cores para a construcao do grafico. Se for
NULL (default) sera utilizado uma paleta de cores padrao. Se for desejavel
utilizar outras cores veja como criar a paleta de cores no exemplo dessa
funcao.}

\item{xlab}{Texto indicando o nome do eixo x.}

\item{ylab}{Texto indicando o nome do eixo y.}

\item{zlab}{Texto indicando o nome do eixo z.}

\item{main}{Texto indicando o nome do grafico.}
}
\value{
A funcao retorna um grafico 3D.
}
\description{
Esta funcao proporciona a criacao de um grafico de superficie
resposta (3D). Para isso, deve-se ter como entrada o output da funcao
'AjustarRegressao'.
}
\examples{
#'  ########################################################################
 ########################################################################
  #Exemplo 1: Experimento sem delineamento
  data("Dados1")
  res=AjustarRegressao(Dados = Dados1,
  design=1,
  verbose=FALSE)
  plot3D(res)
  ##########################
  #Criando paleta de cores
  col0 = colorRampPalette(c('white', 'cyan', '#007FFF', 'blue','#00007F'))
  col1 = colorRampPalette(c('#7F0000', 'red', '#FF7F00', 'yellow', 'white',
                            'cyan', '#007FFF', 'blue','#00007F'))
  col2 = colorRampPalette(c('#67001F', '#B2182B', '#D6604D', '#F4A582',
                            '#FDDBC7', '#FFFFFF', '#D1E5F0', '#92C5DE',
                            '#4393C3', '#2166AC', '#053061'))
  col3 = colorRampPalette(c('red', 'white', 'blue'))
  col4 = colorRampPalette(c('#7F0000', 'red', '#FF7F00', 'yellow', '#7FFF7F',
                            'cyan', '#007FFF', 'blue', '#00007F'))


  plot3D(res,cor=col4(200),xlab="Comprimento (cm)",ylab="Largura (cm)",
  zlab="Area (cm2)")


 ########################################################################
 ########################################################################
 #Exemplo 2: Experimento sem delineamento
  data("Dados2")
  res=AjustarRegressao(Dados = Dados2, design=1,verbose=TRUE)
  plot3D(res,cor=col1(200),xlab="Acucar (\%)",ylab="Banana (\%)",
  zlab="Aceitabilidade")




  #Exemplo 3: Experimento com delineamento (DIC)
  data("Dados3")
  res=AjustarRegressao(Dados = Dados3, design=2,verbose=TRUE)
  plot3D(res,cor=col1(200),xlab="N (K/ha)",ylab="K (Kg/ha)")


  #Exemplo 4: Experimento com delineamento (DBC)
  data("Dados3")
  res=AjustarRegressao(Dados = Dados3, design=3,verbose=TRUE)
  plot3D(res,cor=col1(200),modelo = 10,xlab="N (K/ha)",ylab="K (Kg/ha)")
}
\references{
Tutoriais onlines:
https://www.youtube.com/playlist?list=PLvth1ZcREyK6OUnWVs-hnyVdCB1xuxbVs
}
\seealso{
\code{\link{plot2D}}, \code{\link{predict3D}},
\code{\link{AjustarRegressao}}
}
