/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.mock;

import java.util.ArrayList;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.MultivariableHierarchicalMetaAnalysis;
import org.ohdsi.metaAnalysis.MultivariatePrior;
import org.ohdsi.mock.MockCyclops;

public class CyclopsHierarchicalAnalysisMock {
    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        ArrayList<MockCyclops> mocks = new ArrayList<MockCyclops>();
        ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
        int i = 0;
        while (i < 4) {
            MockCyclops mock = new MockCyclops();
            mocks.add(mock);
            dataModels.add(mock.getModel());
            ++i;
        }
        MultivariableHierarchicalMetaAnalysis.HierarchicalMetaAnalysisConfiguration cg = new MultivariableHierarchicalMetaAnalysis.HierarchicalMetaAnalysisConfiguration();
        cg.tauDf = 10.0;
        MultivariableHierarchicalMetaAnalysis analysis = new MultivariableHierarchicalMetaAnalysis(dataModels, new MultivariatePrior.MultivariateNormal(dataModels, cg), cg);
        System.err.println("Running hierarchical model");
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
        MultivariableHierarchicalMetaAnalysis analysis2 = new MultivariableHierarchicalMetaAnalysis(dataModels, new MultivariatePrior.IndependentNormal(dataModels, cg), cg);
        System.err.println("Running independent model");
        Runner runner2 = new Runner(analysis2, chainLength, burnIn, subSampleFrequency, 666.0);
        runner2.run();
        runner2.processSamples();
        for (MockCyclops mock : mocks) {
            mock.close();
        }
    }
}

