% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultParser.R
\name{ResultParser}
\alias{ResultParser}
\title{Parses request and results files returned from our Event Study API
interface.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
This result file parser works currently only with csv files. Please read
the vignette for further details (coming soon). We will restructure our 
result reports soon. So, this function may change dramatically. This object 
can be used for plotting your results.
}
\section{Methods}{


\describe{
  \item{\code{new(dir)}}{This method is used to create object of this class 
  with \code{dir} as the directory of result files.}
  \item{\code{parseReport(path = "analysis_report.csv")}}{This method 
  parses the analysis report file (analysis_report.csv).}
  \item{\code{parseAR(path = "ar_results.csv")}}{This method parses the 
  abnormal return file (ar_results.csv). Furthermore, it triggers 
  \code{parseReport} and join firm and index name.}
  \item{\code{parseCAR(path = "car_results.csv")}}{This method parses the 
  cumulative abnormal return file (ar_results.csv). Furthermore, it triggers 
  \code{parseReport} and join firm and index name.}
}
}

\examples{
\dontrun{
# Assume you already performed an Event Study and result files are saved in 
# the actual working directory.
estParser <- ResultParser$new()

# parse request file
estParser$parseRequestFile("01_RequestFile.csv")

# parse result files
estParser$parseReport("Analysis report.csv")
estParser$parseAR("AR results.csv")
estParser$parseAAR("AAR results.csv")
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{destDir}}{Result dir.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResultParser-get_request_file}{\code{ResultParser$get_request_file()}}
\item \href{#method-ResultParser-get_analysis_report}{\code{ResultParser$get_analysis_report()}}
\item \href{#method-ResultParser-get_ar}{\code{ResultParser$get_ar()}}
\item \href{#method-ResultParser-get_car}{\code{ResultParser$get_car()}}
\item \href{#method-ResultParser-get_aar}{\code{ResultParser$get_aar()}}
\item \href{#method-ResultParser-get_caar}{\code{ResultParser$get_caar()}}
\item \href{#method-ResultParser-clone}{\code{ResultParser$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_request_file"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_request_file}{}}}
\subsection{Method \code{get_request_file()}}{
Parse request file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_request_file(path = "01_RequestFile.csv")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to request file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_analysis_report"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_analysis_report}{}}}
\subsection{Method \code{get_analysis_report()}}{
Parse request file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_analysis_report(path = "analysis_report.csv")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to request file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_ar"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_ar}{}}}
\subsection{Method \code{get_ar()}}{
Parse request file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_ar(
  path = "ar_results.csv",
  analysis_report_tbl = NULL,
  request_tbl = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to request file.}

\item{\code{analysis_report_tbl}}{PArsed analysis report}

\item{\code{request_tbl}}{parsed request file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_car"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_car}{}}}
\subsection{Method \code{get_car()}}{
Parse Cumulative Abnormal Return
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_car(path = "car_results.csv", analysis_report_tbl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to the CAR result CSV file.}

\item{\code{analysis_report_tbl}}{The analyis report table. It will be used for extracting the group.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_aar"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_aar}{}}}
\subsection{Method \code{get_aar()}}{
Parse AAR results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_aar(path = "aar_results.csv", analysis_report = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to aar result file.}

\item{\code{analysis_report}}{Extracted analysis report}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-get_caar"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-get_caar}{}}}
\subsection{Method \code{get_caar()}}{
Parse caar results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$get_caar(path = "caar_results.csv")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to caar result file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultParser-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResultParser-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
