% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVCApplicationInput.R
\docType{data}
\name{AVCApplicationInput}
\alias{AVCApplicationInput}
\title{Abnormal Volume Calculation Parameters}
\format{\code{\link[R6]{R6Class}} object.}
\usage{
AVCApplicationInput
}
\value{
a ESTParameters R6 object
}
\description{
This R6 class defines the parameters for the Abnormal Volume Event Study. 
We recommend to use the \code{set} functionality to setup your Event Study, 
as we check input parameters.

For more details see the help vignette:
\code{vignette("parameters_eventstudy", package = "EventStudy")}
}
\section{Methods}{

\describe{
  \item{\code{$new()}}{Constructor for AVCApplicationInput}
  \item{\code{$setEMail(eMail)}}{Set the e-Mail address for reporting. This 
  functionality is currently not working}
  \item{\code{$setBenchmarkModel(model = 'mm')}}{Setter for the benchmark
  models}
  \item{\code{$setReturnType(returnType)}}{Setter for the return type (log 
  or simple)}
  \item{\code{$setTestStatistics(testStatistics)}}{Setter for the test 
  statistics}
}
}

\section{Arguments}{

\describe{
 \item{AVCApplicationInput}{An \code{AVCApplicationInput} object}
 \item{eMail}{An E-Mail address in \code{String} format}
 \item{model}{A benchmark model in \code{String} format}
 \item{returnType}{A return type in \code{String} format}
 \item{testStatistics}{A \code{String} vector with test statistics}
}
}

\examples{
\dontrun{
# get files for our S&P500 example; 3 files are written in the current 
# working directory
getSP500ExampleFiles()

# Generate a new parameter object
avcParams <- AVCApplicationInput$new()

# set test statistics
arcParams$setBenchmarkModel("garch")

# Setup API object
apiKey <- "{Your API key}"
estSetup <- EventStudyAPI$new()
estSetup$authentication(apiKey)

# Perform Event Study
estSetup$performEventStudy(estParams = avcParams, 
                           dataFiles = c("request_file" = "01_RequestFile.csv",
                                         "firm_data"    = "02_firmData.csv",
                                         "market_data"  = "03_marketData.csv"))

# Download task results and save them in the actiual working directory
estSetup$getTaskResults()
}

}
\seealso{
\url{https://www.eventstudytools.com/axc/upload}
}
\keyword{datasets}
