% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{post_ercp_pancreatitis_tbl_df}
\alias{post_ercp_pancreatitis_tbl_df}
\title{Indomethacin for Post-ERCP Pancreatitis}
\format{
A tibble with 602 observations and 33 variables:
\describe{
  \item{id}{Numeric subject identifier}
  \item{site}{Factor indicating study site (4 levels)}
  \item{age}{Numeric age of the participant}
  \item{risk}{Numeric risk score}
  \item{gender}{Factor indicating gender (2 levels)}
  \item{outcome}{Factor indicating study outcome (2 levels)}
  \item{sod}{Factor indicating presence of sphincter of Oddi dysfunction (2 levels)}
  \item{pep}{Factor indicating presence of post-ERCP pancreatitis (2 levels)}
  \item{recpanc}{Factor indicating recurrent pancreatitis (2 levels)}
  \item{psphinc}{Factor indicating pancreatic sphincterotomy (2 levels)}
  \item{precut}{Factor indicating precut sphincterotomy (2 levels)}
  \item{difcan}{Factor indicating difficult cannulation (2 levels)}
  \item{pneudil}{Factor indicating pneumatic dilation (2 levels)}
  \item{amp}{Factor indicating ampullary interventions (2 levels)}
  \item{paninj}{Factor indicating pancreatic injury (2 levels)}
  \item{acinar}{Factor indicating acinarization (2 levels)}
  \item{brush}{Factor indicating brushing procedures (2 levels)}
  \item{asa81}{Factor indicating ASA 81 mg use (3 levels)}
  \item{asa325}{Factor indicating ASA 325 mg use (3 levels)}
  \item{asa}{Factor indicating ASA status (3 levels)}
  \item{prophystent}{Factor indicating prophylactic stent placement (2 levels)}
  \item{therastent}{Factor indicating therapeutic stent use (2 levels)}
  \item{pdstent}{Factor indicating pancreatic duct stent (2 levels)}
  \item{sodsom}{Factor indicating somatostatin use for SOD (2 levels)}
  \item{bsphinc}{Factor indicating biliary sphincterotomy (2 levels)}
  \item{bstent}{Factor indicating biliary stent (2 levels)}
  \item{chole}{Factor indicating cholecystectomy (2 levels)}
  \item{pbmal}{Factor indicating presence of pancreaticobiliary malignancy (2 levels)}
  \item{train}{Factor indicating if performed by trainee (2 levels)}
  \item{status}{Factor indicating trial status (2 levels)}
  \item{type}{Factor indicating procedure type (4 levels)}
  \item{rx}{Factor indicating treatment group: placebo or indomethacin (2 levels)}
  \item{bleed}{Numeric bleeding indicator}
}
}
\source{
Data taken from the medicaldata package version 0.2.0.
}
\usage{
data(post_ercp_pancreatitis_tbl_df)
}
\description{
This dataset, post_ercp_pancreatitis_tbl_df, is a tibble containing results from a randomized,
placebo-controlled, prospective 2-arm trial of rectal indomethacin (100 mg) versus placebo
to prevent post-ERCP pancreatitis in 602 participants, as reported by Elmunzer, Higgins, et al. (2012)
in the New England Journal of Medicine.
}
\details{
The dataset name has been kept as 'post_ercp_pancreatitis_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
