/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.ElementModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class PlottingElement
implements Transferable {
    protected static DataFlavor flavor = new DataFlavor(PlottingElement.class, "Plot element");
    private ElementModel model;
    private ImageIcon icon;
    public static DataFlavor DATAFLAVOR = new DataFlavor(PlottingElement.class, "Plotting element");

    public PlottingElement(ElementModel elementModel) {
        this.model = elementModel;
        this.setIconFromUrl(elementModel.getIconUrl());
    }

    public void setIconFromUrl(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            this.icon = new ImageIcon(uRL);
        }
    }

    public Object clone() {
        PlottingElement plottingElement = new PlottingElement((ElementModel)this.model.clone());
        return plottingElement;
    }

    public JDialog getJDialog() {
        return this.model.getView();
    }

    public Image getImage() {
        return this.icon.getImage();
    }

    public void setImage(Image image) {
        this.icon = new ImageIcon(image);
    }

    public ElementModel getModel() {
        return this.model;
    }

    public void setModel(ElementModel elementModel) {
        this.model = elementModel;
        this.setIconFromUrl(elementModel.getIconUrl());
    }

    public boolean isActive() {
        return this.model.isActive();
    }

    public void setActive(boolean bl) {
        this.model.setActive(bl);
    }

    public JPanel makeComponent() {
        String[] stringArray;
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (this.isActive()) {
            jLabel = new JLabel(this.icon);
        } else {
            stringArray = this.getClass().getResource("/icons/edit_remove_32.png");
            jLabel = new JLabel(new ImageIcon((URL)stringArray));
        }
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        stringArray = this.model.getName().split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            JLabel jLabel2 = new JLabel(stringArray[i]);
            jLabel2.setAlignmentX(0.5f);
            jLabel2.setFont(new Font("Dialog", 0, 12));
            jPanel.add(jLabel2);
        }
        if (!this.isActive()) {
            jPanel.setPreferredSize(new Dimension(80, 70));
        }
        jPanel.setBorder(new EtchedBorder());
        return jPanel;
    }

    public static DataFlavor getFlavor() {
        return flavor;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{flavor};
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return true;
    }
}

