% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListTables.R
\name{dbListTables,DatabaseConnectorConnection-method}
\alias{dbListTables,DatabaseConnectorConnection-method}
\title{List remote tables}
\usage{
\S4method{dbListTables}{DatabaseConnectorConnection}(conn, databaseSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{...}{Not used}
}
\value{
\code{dbListTables()}
returns a character vector
that enumerates all tables
and views
in the database.
Tables added with \code{\link[DBI:dbWriteTable]{dbWriteTable()}}
are part of the list.
As soon a table is removed from the database,
it is also removed from the list of database tables.

The same applies to temporary tables if supported by the database.

The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
Returns the unquoted names of remote tables accessible through this
connection.
This should include views and temporary objects, but not all database backends
(in particular \pkg{RMariaDB} and \pkg{RMySQL}) support this.

}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
