% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connect.R
\name{dbms}
\alias{dbms}
\title{Get the database platform from a connection}
\usage{
dbms(connection)
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[=dbConnect]{dbConnect()}}.}
}
\value{
The name of the database (dbms) used by SqlRender
}
\description{
The SqlRender package provides functions that translate SQL from OHDSI-SQL to
a target SQL dialect. These function need the name of the database platform to
translate to. The \code{dbms} function returns the dbms for any DBI
connection that can be passed along to SqlRender translation functions (see example).
}
\examples{
library(DatabaseConnector)
con <- connect(dbms = "sqlite", server = ":memory:")
dbms(con)
#> [1] "sqlite"
SqlRender::translate("DATEADD(d, 365, dateColumn)", targetDialect = dbms(con))
#> "CAST(STRFTIME('\%s', DATETIME(dateColumn, 'unixepoch', (365)||' days')) AS REAL)"
disconnect(con)
}
