% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simAlleleFreqs.R
\name{simAlleleFreqs}
\alias{simAlleleFreqs}
\title{Simulate Allele Frequencies}
\usage{
simAlleleFreqs(
  nLoci = 10,
  allelesPerLocus = rep(10, nLoci),
  shape = rep(3, nLoci)
)
}
\arguments{
\item{nLoci}{\eqn{L} the number of loci in the multiplex}

\item{allelesPerLocus}{the number of alleles per locus}

\item{shape}{the shape parameter}
}
\value{
a list with elements \code{locus.}\eqn{l} where \eqn{l=1,\ldots,L}, each 
of which are vectors of length \code{allelesPerLocus[l]}, consisting of allele 
frequencies for that locus
}
\description{
Simulate some allele frequencies using Dirichlet Random variables
}
\examples{
set.seed(123)
simAlleleFreqs()

}
