% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowIntFilter.R
\name{lowIntFilter}
\alias{lowIntFilter}
\title{Apply low intensity filters to a DGEobj}
\usage{
lowIntFilter(
  dgeObj,
  countThreshold,
  zfpkmThreshold,
  fpkThreshold,
  tpmThreshold,
  sampleFraction = 0.5,
  geneLength,
  verbose = FALSE
)
}
\arguments{
\item{dgeObj}{A DGEobj with RNA-Seq (counts) data (Required)}

\item{countThreshold}{Genes below this threshold are removed (10 is recommended).}

\item{zfpkmThreshold}{Genes below this threshold are removed. (-3.0 is recommended)}

\item{fpkThreshold}{Genes below this threshold are removed. (5 is recommended)}

\item{tpmThreshold}{Genes below this threshold are removed.}

\item{sampleFraction}{The proportion of samples that must meet the thresholds
(Default = 0.5). Range > 0 and <= 1.}

\item{geneLength}{Vector of geneLengths for rows of dgeObj. Required for FPK and
zFPKM filters, unless dgeObj is a DGEobj.  If a DGEobj is supplied, geneLength is
retrieved from the DGEobj, unless supplied by the geneLength argument.}

\item{verbose}{Prints messages about the filtering process.}
}
\value{
Same class as input object with low intensity rows removed
}
\description{
Takes a DGEobj as input and applies a combination of low intensity filters as
specified by the user. Raw count, zFPKM, TPM, and/or FPK filters are
supported.  A gene must pass all active filters.  Not setting a threshold
argument inactivates that threshold.
}
\examples{
\dontrun{
  myDGEobj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
  dim(myDGEobj)

  # Simple count threshold in at least 3/4ths the samples
  myDGEobj <- lowIntFilter(myDGEobj,
                           countThreshold = 10,
                           sampleFraction = 0.5)
  dim(myDGEobj)

  # Count and FPK thresholds
  myDGEobj <- lowIntFilter(myDGEobj,
                           countThreshold = 10,
                           fpkThreshold = 5,
                           sampleFraction = 0.5)
  dim(myDGEobj)
}

}
