% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Medellin_rain_tbl_df}
\alias{Medellin_rain_tbl_df}
\title{Medellin Rainfall Information}
\format{
A tibble with 185,705 observations and 8 variables:
\describe{
  \item{station_id}{Numeric identifier for the rain observation station.}
  \item{lat}{Numeric value representing the latitude of the station.}
  \item{lon}{Numeric value representing the longitude of the station.}
  \item{date}{Date of the rainfall observation.}
  \item{year}{Numeric year of the observation.}
  \item{month}{Numeric month of the observation.}
  \item{day}{Numeric day of the observation.}
  \item{rainfall}{Numeric value representing the amount of rainfall in millimeters.}
}
}
\source{
Originally taken from the tidychangepoint package version 0.0.1.
}
\usage{
data(Medellin_rain_tbl_df)
}
\description{
This dataset, Medellin_rain_tbl_df, is a tibble containing information about rainfall
measurements in Medellin, Colombia, including station identifiers, geographical coordinates,
date of observation, and rainfall values.
}
\details{
The dataset name has been kept as Medellin_rain_tbl_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
