% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divipola.R
\name{name_to_standard_mun}
\alias{name_to_standard_mun}
\title{Translate municipality names to  official municipalities' DIVIPOLA names}
\usage{
name_to_standard_mun(department_name, municipality_name)
}
\arguments{
\item{department_name}{character vector with the names of the
departments containing the municipalities.}

\item{municipality_name}{character vector with the names to be translated.}
}
\value{
character vector with the DIVIPOLA name of the municipalities.
}
\description{
Municipality names are usually manually input, which leads to multiple errors
and lack of standardization. This functions translates municipality names to
their respective official names from DIVIPOLA.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dptos <- c("Bogota", "Tolima")
mpios <- c("Bogota DC", "CarmendeApicala")
name_to_standard_mun(dptos, mpios)
\dontshow{\}) # examplesIf}
}
