% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCodeUse.R
\name{tableCodeUse}
\alias{tableCodeUse}
\title{Format the result of summariseCodeUse into a table.}
\usage{
tableCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate_name"),
  groupColumn = character(),
  hide = character(),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type "code_use".}

\item{type}{Type of desired formatted table. To see supported formats
use visOmopResults::tableType()}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"codelist_name", "standard_concept_name", "standard_concept_id",
"estimate_name", "source_concept_name", "source_concept_id", "domain_id". If
results are stratified, "year", "sex", "age_group" can also be used.
Alternatively, it can include other names to use as overall header labels.}

\item{groupColumn}{Variables to use as group labels. Allowed columns are:
"cdm_name", "codelist_name", "standard_concept_name", "standard_concept_id",
"estimate_name", "source_concept_name", "source_concept_id", "domain_id". If
results are stratified, "year", "sex", "age_group" can also be used.
These cannot be used in header.}

\item{hide}{Table columns to exclude, options are: "cdm_name",
"codelist_name", "year", "sex", "age_group", "standard_concept_name",
"standard_concept_id", "estimate_name", "source_concept_name",
"source_concept_id", "domain_id". If results are stratified, "year", "sex",
"age_group" can also be used. These cannot be used in header or groupColumn.}

\item{.options}{Named list with additional formatting options.
visOmopResults::tableOptions() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCodeUse result.
}
\description{
Format the result of summariseCodeUse into a table.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomia_dir())
cdm <- CDMConnector::cdm_from_con(con,
                                  cdm_schem = "main",
                                  write_schema = "main")
acetiminophen <- c(1125315,  1127433, 40229134,
40231925, 40162522, 19133768,  1127078)
poliovirus_vaccine <- c(40213160)
cs <- list(acetiminophen = acetiminophen,
          poliovirus_vaccine = poliovirus_vaccine)
results <- summariseCodeUse(cs,cdm = cdm)
tableCodeUse(results)
CDMConnector::cdmDisconnect(cdm)
}


}
