% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Subset.R
\name{CST_Subset}
\alias{CST_Subset}
\title{Subset an object of class s2dv_cube}
\usage{
CST_Subset(x, along, indices, drop = FALSE, var_dim = NULL, dat_dim = NULL)
}
\arguments{
\item{x}{An object of class \code{s2dv_cube} to be sliced.}

\item{along}{A vector with references to the dimensions to take the subset 
from: either integers or dimension names.}

\item{indices}{A list of indices to take from each dimension specified in 
'along'. If a single dimension is specified in 'along', it can be directly
provided as an integer or a vector.}

\item{drop}{Whether to drop all the dimensions of length 1 in the resulting 
array, none, only those that are specified in 'along', or only those that 
are not specified in 'along'. The possible values are: 'all' or TRUE, 'none'
or FALSE, 'selected', and 'non-selected'. The default value is FALSE.}

\item{var_dim}{A chatacter string indicating the name of the variable
dimension. The default value is NULL.}

\item{dat_dim}{A character string indicating the name of dataset dimension.
The default value is NULL.}
}
\value{
An object of class \code{s2dv_cube} with similar data, coordinates and 
 attributes as the \code{x} input, but with trimmed or dropped dimensions.
}
\description{
This function allows to subset (i.e. slice, take a chunk of) the data inside
an object of class \code{s2dv_cube} and modify the dimensions, coordinates and
attributes accordingly, removing any variables, time steps and spatial
coordinates that are dropped when subsetting. It ensures that the information
inside the s2dv_cube remains coherent with the data it contains.\cr\cr
As in the function \code{Subset} from the ClimProjDiags package, the 
dimensions to subset along can be specified via the parameter \code{along} 
either with integer indices or by their name.\cr\cr
There are additional ways to adjust which dimensions are dropped in the 
resulting object: either to drop all, to drop none, to drop only the ones that
have been sliced or to drop only the ones that have not been sliced.\cr\cr
The \code{load_parameters} and \code{when} attributes of the original cube
are preserved. The \code{source_files} attribute is subset along the
\code{var_dim} and \code{dat_dim} dimensions.
}
\examples{
#Example with sample data:
# Check original dimensions and coordinates
lonlat_temp$exp$dims
names(lonlat_temp$exp$coords)
# Subset the s2dv_cube
exp_subset <- CST_Subset(lonlat_temp$exp,
                        along = c("lat", "lon"),
                        indices = list(1:10, 1:10),
                        drop = 'non-selected')
# Check new dimensions and coordinates
exp_subset$dims
names(exp_subset$coords)

}
\seealso{
\link[ClimProjDiags]{Subset}
}
\author{
Agudetse Roures Victoria, \email{victoria.agudetse@bsc.es}
}
