% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/malinvaud.R
\name{malinvaud}
\alias{malinvaud}
\title{Malinvaud's test for significance of the CA dimensions}
\usage{
malinvaud(data)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}
}
\description{
This function allows you to perform the Malinvaud's test, which assesses the
significance of the CA dimensions.
}
\details{
The function returns both a table in the R console and a plot. The former
lists relevant information, among which the significance of each CA
dimension. The dot chart graphically represents the p-value of each dimension;
dimensions are grouped by level of significance; a red reference lines
indicates the 0.05 threshold.
}
\examples{
data(greenacre_data)

#perform the Malinvaud test using the 'greenacre_data' dataset
#and store the output table in a object named 'res'
res <- malinvaud(greenacre_data)

}
\seealso{
\code{\link{sig.dim.perm.scree}}
}
\keyword{malinvaud}
