\name{getAttractors}
\Rdversion{1.1}
\alias{getAttractors}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Identify attractors in a Boolean network}

\description{Identifies attractors (cycles) in a supplied Boolean network}
\usage{
getAttractors(network, 
              method=c("exhaustive","random","chosen"), 
              startStates=list(),
              genesON = c(), genesOFF = c(), 
              canonical=TRUE)
}

\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}}, generated by \code{\link{generateRandomNKNetwork}}, or reconstructed by \code{\link{reconstructNetwork}}.
}
  \item{method}{
  	The search method to be used. If "exhaustive", attractors are identified by exhaustive search of all 2^n states (where n is the number of genes that are not set to a fixed value). The maximum number of genes allowed for exhaustive search is 29, as R cannot allocate memory for larger state tables.
  	
  	If \code{method} is "random", \code{startStates} is interpreted as an integer value specifying the number of states to be generated randomly. The algorithm is then initialized with these random states and identifies the attractors to which these states lead.
  	
  	If \code{method} is "chosen", \code{startStates} is interpreted as a list of binary vectors, each specifying one input state. Each vector must have \code{length(network$genes)} elements with 0 or 1 values. The algorithm identifies the attractors to which the supplied states lead.
  	
  	If \code{method} is not supplied, the desired method is inferred from the type of \code{startStates}. By default, if neither \code{method} nor \code{startStates} are provided, an exhaustive search is performed.
  }
  
  \item{startStates}{
  	The value of \code{startStates} depends on the chosen method. See \code{method} for more details.
  }  
  \item{genesON}{
	A vector of genes whose values are fixed to 1 (which reduces the complexity of the truth table)
}
  \item{genesOFF}{
	A vector of genes whose value are fixed to 0 (which reduces the complexity of the truth table)
}
  \item{canonical}{
	If set to true, the states in the attractors are rearranged such that the state whose binary encoding
makes up the smallest number is the first element of the vector. This ensures that attractors found by different heuristic runs of \code{getAttractors} are comparable, as the cycles may have been entered at different states in different runs of the algorithm.
}
}
\details{Attractors are identified by repeated state transitions from the initial states. Printing the return value of the function using \code{\link{print}} visualizes the identified attractors.}

\value{A list of class \code{AttractorInfo} with components
  \item{attractors}{A list of attractors. Each element is a 2-element list with the following components:
  \describe{
  	\item{involvedStates}{A matrix containing the states that make up the attractor. Each column represents one state. The entries are decimal numbers that internally represent the states of the genes. The number of rows depends on the number of genes in the network: The first 32 genes are encoded in the first row, genes 33-64 are encoded in the second row, etc.}
  	\item{basinSize}{The number of states in the basin of attraction. Details on the states in the basin can be retrieved via \code{\link{getBasinOfAttraction}}.}
  	}}
  \item{stateInfo}{A summary structure of class \code{BooleanStateInfo} containing information on the transition table. It has the following components:
  \describe{
  	\item{initialStates}{If \code{method} is "random" or "chosen", this is a matrix describing the initial states that lead to the states in \code{table} after a state transition.	If \code{method} is "exhaustive", this component is \code{NULL}. In this case, the initial states can be inferred, as all states are used. The format of the matrix is described in \code{involvedStates}.}
  	\item{table}{The result vector of the transition table as a matrix with one column for each state. These are encoded bit vectors in decimal numbers as described above.}
  	\item{attractorAssignment}{A vector that corresponds to the entries in \code{table} and describes the attractor index in \code{attractors} to which successive transitions from the described state finally lead}
  	\item{stepsToAttractor}{Referring to \code{attractorAssignment}, the number of transitions needed to reach the attractor}
  }
  The structure supports pretty printing using the \code{\link{print}} method.}
}
\seealso{
\code{\link{loadNetwork}}, \code{\link{generateRandomNKNetwork}}, \code{\link{plotAttractors}}, \code{\link{attractorsToLaTeX}}, \code{\link{getTransitionTable}}, \code{\link{getBasinOfAttraction}}, \code{\link{getStateSummary}}
}
\examples{
library(BoolNet)

# load example data
data(cellcycle)

# get attractors by exhaustive search
attractors <- getAttractors(net)

# plot attractors side by side
par(mfrow=c(2,length(attractors$attractors)))
plotAttractors(attractors)

# finds the attractor with 7 states
attractors <- getAttractors(net,method="chosen",
                            startStates=list(rep(1,length(net$genes))))
plotAttractors(attractors)

# finds the attractor with 1 state
attractors <- getAttractors(net,method="chosen",
                            startStates=list(rep(0,length(net$genes))))
plotAttractors(attractors)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Boolean network
	attractor
	cycle
	basin}
