% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdwproduct}
\alias{bdwproduct}
\title{Matrix - Weighted vector Multiplication with numerical or DelayedArray data}
\usage{
bdwproduct(X, w, op)
}
\arguments{
\item{X}{numerical or Delayed Array matrix}

\item{w}{vector with weights}

\item{op}{string indicating if operation 'XtwX' and 'XwXt' for weighted cross product (Matrix - Vector - Matrix) or 'Xw' and 'wX' for weighted product (Matrix - Vector)}
}
\value{
numerical matrix
}
\description{
This function performs a weighted product of a matrix(X) with a weighted diagonal matrix (w)
}
\examples{

library(DelayedArray)

n <- 100
p <- 60

X <- matrix(rnorm(n*p), nrow=n, ncol=p)

u <- runif(n)
w <- u * (1 - u)
ans <- bdwproduct(X, w,"xtwx")

# with Delayed Array

DX <- DelayedArray(X)

ans <- bdwproduct(DX, w,"xtwx")

}
