% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdlm_paral.R
\name{bdlm_paral}
\alias{bdlm_paral}
\title{Linear regression using MLR-MR algorithm}
\usage{
bdlm_paral(Y, model, blocks, threads = NULL)
}
\arguments{
\item{Y, }{numerical matrix column with response variable}

\item{model, }{numerical matrix with paired observations of the predictor variable X}

\item{blocks, }{integer with number of blocks we want to split matrix if null matrix is splited in blocks as maximum of 1000 variables per block}

\item{threads, }{threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}
}
\value{
Lineal regression coefficients
}
\description{
Linear regression for Big Data using MLR-MR algorithm to perform lm regression with big data :  https://isglobal-brge.github.io/Master_Modelling/dealing-with-big-data-in-r.html#linear-regression-for-big-data
}
\examples{
# with numeric matrix

library(BigDataStatMeth)
data(mtcars)

Y <- mtcars$mpg
X <- model.matrix(~ wt + cyl, data=mtcars)
m <- 7


res <- bdlm_paral( X, Y, m, 1)
res

}
