% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{make_arff_row_col}
\alias{make_arff_row_col}
\title{Transform R matrix object to BiBit input files.}
\usage{
make_arff_row_col(matrix, name = "data", path = "")
}
\arguments{
\item{matrix}{The binary input matrix.}

\item{name}{Basename for the 3 input files.}

\item{path}{Directory path where to write the 3 input files to.}
}
\value{
3 input files for BiBit:
\itemize{
\item 1 \code{.arff} file containing the data.
\item 1 \code{.csv} file for the row names. The file contains 1 column of names without quotation.
\item 1 \code{.csv} file for the column names. The file contains 1 column of names without quotation.
}
}
\description{
Transform the R matrix object to 1 \code{.arff} for the data and 2 \code{.csv} files for the row and column names. These are the 3 files required for the original BiBit Java algorithm
The path of these 3 files can then be used in the \code{arff_row_col} parameter of the \code{bibit} function.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]

make_arff_row_col(matrix=data,name="data",path="")

result <- bibit(data,minr=5,minc=5,
                arff_row_col=c("data_arff.arff","data_rownames.csv","data_colnames.csv"))
}
}
\author{
Ewoud De Troyer
}

